#!/bin/gawk -f

$0 ~ /^TTAGCGGA(AA|TT|GG|CC){4}(A{4}|T{4}|G{4}|C{4})$/{
    # A DNS szekvencia elvárt kezdete az AATCGCCT szekvencia komplementere:
    # ^TTAGCGGA, mivel A komplementere T és C komplomentere G, a "^" karakter jelenti azt, hogy ezzel a mintával kell kezdődnie a soroknak.

    # Az utolsó 4 karakternek egyező kell legyen a 4 bázis valamelyikével: (A{4}|T{4}|G{4}|C{4})$, ahol
    # az "A", "T", "G", és "C" közül vesz egy karaktert, ezt pontosan 4x ({4}) kell egymás után leírnia,
    # és ezzel a sorozattal kell befejeződnie, ezért kell a $ karakter a végére.

    # Eddig lefedtünk összesen 8 kezdő karaktert és a végén még 4-et, ami összesen 12,
    # továbbá tudjuk, hogy az egész DNS szekvencia hossza összesen 20 karakter,
    # tehát még 8 karakter kerül ezek közé. A feladat szerint itt a DNS bázisok csak duplázódva jelenhetnek meg,
    # tehát VAGY szerepel egymás mellett kétszer az "A" VAGY szerepel egymás mellett kétszer a "T", ... Ennek a szintaxisa pedig:
    # (AA|TT|GG|CC){4} ahol a "|" karakter jelenti az alternációt (vagyolást).
    # És ebből, mivel kettessével ismétlődnek, hogy lefedjük a maradék 8 karaktert, így ezekből kell összesen 4 darab ({4}).

	# Azon sorokat kiírjuk, amelyekre illeszkedik ez a reguláris kifejezés.
	print $0
}
