#!/bin/gawk -f

BEGIN {
	# Elválasztó karakter
	FS = ";"
}

{
	# Létrehozunk egy datum tömböt, ebben tároljuk el külön az év, hónap, és nap értékét.
	# 1:év, 2:hónap, 3:nap
	split($2,datum,".")
	
	# Ha nem találkoztunk még ilyen kurzussal, akkor a ezen az indexen nem létezik tömbelem.
	if(!($1 in kurzus)){ 
		#Ekkor értékül adjuk az első talált dátumot neki, és lépünk a következő iterációra.
		kurzus[$1] = $2
		next
	}
	# Ha a mostani vizsga alkalom előbb van mint az eddig talált legjobb (leghamarabbi dátum), akkor kicseréljük.
	if(datum[3] < kurzus[$1]){
		kurzus[$1] = $2
	}
}

END {
	for(i in kurzus){
		# Kiíratás a feladat szerint megfelelő formátumban.
		printf("%s;%s\n",i,kurzus[i])
	}
}
