#!/bin/gawk -f

BEGIN {
	# A mezők ";"-vel vannak elválasztva egymástól.
	FS=";"
	# Ebben tartjuk számon, összesen hány órát tud játszani az év folyamán.
	ossz=0
}

# Konkrétan megmondjuk, hogy 2021-gyel kell kezdődjön: ^2021
# Ezt követően helyes az is, ha "."-tal vagy "-"-lel van elválasztva az év a hónaptól: [.-]
# Nem kell ellenőrizni a hónap érvényességét, így elég csak azt mondanunk, hogy két számjegy következik: [0-9]{2}
# Ismét egy elválasztó, most a hónap és a nap között: [.-]
# A NN közül az első 0 es 3 közötti szám lehet: [0-3]
# Tamás azokon a napokon nem játszik, amelyek dátum szerint 3-ra, 5-re vagy 7-re végződnek: [^357], ahol '^' a negálás/komplementer
# Ezzel a dátum feldolgozva, ezt követi egy ";" karakter: ;
# Majd ezek kozul is csak kedden (K) vagy szerdan (SZE) vagy penteken (P) fog jatszani
# Az ezt követő tartalom lényegtelen, így a regex szűrést ezzel befejeztük.
# Meg kell néznünk, hogy aznap játszhat-e legalább 7 órát. A 24 órából kivonjuk az elfoglaltsagot (harmadik oszlop), és ha ez >= 7, megfelelő dátum.

/^2021[.-][0-9]{2}[.-][0-3][^357];(K|SZE|P)/{
	if(24-$3 >= 7){
		print $1
		ossz+=(24-$3)
	}
}

END {
	# Végül kiírjuk, hogy ez összesen hány óra játékot jelent.
	print ossz
}
