#!/bin/gawk -f

BEGIN {
    # Egy db nevű változóban fogjuk a mintára illeszkedő szavak darabszámát eltárolni.
    db=0
}

{
	# Bejárjuk minden sor minden szavát, NF az aktuális sor szavainak számát jelenti.
    for(i = 1; i <= NF; ++i){
        # Minden olyan szót figyeleme veszünk, amely tartalmaz egy számot, majd közvetlenül utána egy % jelet.
        if ($i ~ /[0-9]%/){
            # Kiírunk minden ilyen találatot.
            print $i
            # Majd növeljük a db változó értékét.
            db++
        }
    }
}

END {
	# Végül kiírjuk a talált szavak darabszámát.
    print db
}
