#!/bin/gawk -f

BEGIN {
    # Egy db nevű változóban fogjuk a mintára illeszkedő szavak darabszámát eltárolni.
	db=0
}

{
	# Bejárjuk minden sor minden szavát, NF az aktuális sor szavainak számát jelenti.
	for(i=1;i<=NF;++i){
		# Az adott $i szóra kell illeszkedjen az a reguláris kifejezés, hogy:
		# Kis vagy nagy "m" betűvel kell kezdődnie: [Mm]
		# Ezt követi az "ama" karaktersorozat, melynek utolso "a" karaktere legalább egyszer, de tetszőleges példányban szerepelhet,
		# ezért kell a végére még a "+" karakter.
		if($i~/[Mm]ama+/){
			# Ha találtunk ilyen szót, növeljük a db változó értéket eggyel.
			db++
		}
	}
}

END {
	# Végül kiírjuk a talált szavak darabszámát.
	print db
}
