#!/bin/gawk -f

# A fájlban a mezők ";" karakterrel vannak elválasztva, emiatt az FS értékét átállítjuk ";"-re.
# Továbbá létrehozunk egy osszeg nevű változót, amelyben az A csapat összpontszámát fogjuk számontartani.
BEGIN {
	FS=";"
	osszeg=0
}

# A név oszlopra szeretnénk illeszteni, ez az első oszlop: $1
# A név 1 nagybetűvel kezdődik: ^[A-Z]
# Minimum 5 és maximum 17 kis- vagy nagybetű követi: [a-zA-Z]{5,17}
# Ezt egy "." karakter követi. Ne feledjük, hogy a pontnak speciális jelentése van, ezert vagy \.-t vagy [.]-t használjunk.
# 4 darab számjegy követi, melyek egyike sem lehet 3 vagy 7:
# pl: [01245689]{4} vagy mivel jelen esetben látjuk, hogy mindig csak számok szerepelnek a név végén, használható a [^37]{4} is.
# Erre kell, hogy végződjön, ezért a végére tegyünk "$" karaktert.

$1~/^[A-Z][a-zA-Z]{5,17}\.[^37]{4}$/{
    # Növeljuk az "A" csapat tagjának pontszámával ($2) az osszeg valtozónk értékét.
	osszeg+=$2
}

END {
    # Végül kiírjuk az összeget a képernyőre.
	print osszeg
}
