
function [model,bestAccuracy] = train_svm_classifier(features, labels, stubs)

% Vector features - vector used for the training (nxm) - n feature vectors
% with m features
% Vector labels - labels (classes) of the vector training, (nx1)
% stubs (integer) - to how many stubs is are the features divided.
% size(stubs) - 1 is used for training, remaining one is used for testing
% the classifier. After the best parameters gamma and C are found then
% classifier is trained again
% 
% Function returns SVM model

bestGamma = -14;
bestC = -5;
bestAccuracy = 0; %accurracy in percent
numStubElements = floor(size(features,1)/stubs);

for gamma = -6 : 2
    for C = - 5 : 6

        model = svmtrain(labels(1:numStubElements*(stubs - 1),:) ,features(1:numStubElements*(stubs - 1),:),...
                                                ['-c ', num2str(2^C), ' -g ', num2str(2^gamma)]);
        [predict_label, accuracy, dec_values] = svmpredict(labels((numStubElements*(stubs - 1) + 1):end,:),...
                                                features((numStubElements*(stubs - 1) + 1):end,:), model); % test the training data
        
        % take the accracy mean squared error which is minimal and rember
        % gamma and C values      
        % disp(sprintf('Accuracy for C = %f, gamma = %f is %f percent',[C,gamma,accuracy(1,1)]));
        if accuracy(1,1) > bestAccuracy 
            bestAccuracy = accuracy(1,1);
            bestC = C;
            bestGamma = gamma;
        end
    end;
end

%at the end train with the best C and gamma;
model = svmtrain(features(1:numStubElements*(stubs - 1)), labels(1:numStubElements*(stubs - 1)),...
                                                ['-c ', num2str(2^bestC), ' -g ', num2str(2^bestGamma), ' -b 1']);

