function varargout = texture_browser(varargin)
% TEXTURE_BROWSER M-file for texture_browser.fig
%      TEXTURE_BROWSER, by itself, creates a new TEXTURE_BROWSER or raises the existing
%      singleton*.
%
%      H = TEXTURE_BROWSER returns the handle to a new TEXTURE_BROWSER or the handle to
%      the existing singleton*.
%
%      TEXTURE_BROWSER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TEXTURE_BROWSER.M with the given input arguments.
%
%      TEXTURE_BROWSER('Property','Value',...) creates a new TEXTURE_BROWSER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before texture_browser_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to texture_browser_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help texture_browser

% Last Modified by GUIDE v2.5 12-Jul-2007 16:05:08

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @texture_browser_OpeningFcn, ...
                   'gui_OutputFcn',  @texture_browser_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before texture_browser is made visible.
function texture_browser_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to texture_browser (see VARARGIN)

% Choose default command line output for texture_browser
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes texture_browser wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = texture_browser_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global model;
global feature_centers;
global classes_centers;
global database_directory;
global feature_normalization_coef;
global windowSize;

[FileName,PathName] = uigetfile('*.jpg;*.gif;*.png;');
image = imread(fullfile(PathName,FileName));
    if size(size(image),2) == 3 %image is in rgb
        texture = rgb2gray(image);
    else %image is in grayscale
        texture = image;
    end
axes(handles.axes_input);
imshow(texture);
texture = double(texture);

%Now take out all feature from the texture
[newfeatures] = gatherFeaturesFromTexture(texture,windowSize);

%calculate mean vector and normalize 
meanvector = mean(newfeatures')' ./ feature_normalization_coef;

%calculate the distance between the texture centers and the input texture
distance_map = sum((feature_centers - repmat(meanvector,1,size(feature_centers,2))).^2);
[distances, index] = sort(distance_map); % sort in ascending

%use flipr for flipping
%distances = fliplr(distances);
%index = fliplr(index);

mostsimilar = fullfile(database_directory, classes_centers(index(1,1),:));
axes(handles.axes_output1);
imshow(imread(mostsimilar));

secondmostsimilar = fullfile(database_directory, classes_centers(index(1,2),:));
axes(handles.axes_output2);
imshow(imread(secondmostsimilar));

leastsimilar = fullfile(database_directory, classes_centers(index(1,size(index,2)),:));
axes(handles.axes_output3);
imshow(imread(leastsimilar));

%get me the classes that 


    
% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over pushbutton1.
function pushbutton1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

global model;
global feature_centers;
global classes_centers;
global database_directory;
global feature_normalization_coef;
global windowSize;

windowSize = 96;

database_directory = 'database';

% SVM implementation
[features, classes, feature_centers, classes_centers] = gatherFeaturesFromDatabase(database_directory,windowSize);
%[model, accuracy] = train_svm_classifier(features',classes',5);
feature_normalization_coef = mean(feature_centers')';
%normalize feature centers
feature_centers = feature_centers ./ repmat(feature_normalization_coef,1,size(feature_centers,2));
% nearest neighborhood implementation









