function PredictedLabels=knn(k,TrainPattern,TrainLabel,TestPattern)
%k-nearest neighbor classifier
%Determines distances of all TrainPattern points from TestPattern points
%Outputs TrainLabel associated with nearest TrainPattern point

    S=size(TrainPattern);
    N=S(1,1);
    d=zeros(N,1);%creates specified space for distance column vector

    for i=1:N%creates distance column vector with N rows
        x1=TrainPattern(i,1);
        x2=TestPattern(row,1);
        x=(x1-x2)^2;
        y1=TrainPattern(i,2);
        y2=TestPattern(row,2);
        y=(y1-y2)^2;
        d(i,1)=sqrt(x+y);
        if TrainLabel(i,1)>0.5%creates scatter plot of train patterns with labels
            plot(TrainPattern(i,1),TrainPattern(i,2),'bh')
        else
            plot(TrainPattern(i,1),TrainPattern(i,2),'kh')
        end
    end

    %M(:,row) = getframe(gcf);
    legend('Test Pattern','Train Patterns and Labels',-1)
    [cldvalues,clIndx]=sortrows(d);%determines closest distances and their indices
    for j=1:N
        CLTrainLabels(j,1)=TrainLabel(clIndx(j,1),1);
    end
    Closest_Train_Labels=CLTrainLabels(1:k(1,1),1);%displays "kth" closest labels
    for r=1:k(1,1)
        if Closest_Train_Labels(r,1)>0.5
            PredictedLabels(r,1)={'Blue'};
        else
            PredictedLabels(r,1)={'Black'};
        end
    end

%disp('Creating AVI file...')
%movie2avi(M,'k_classifier.avi','compression','Indeo5','FPS',1,'VideoName','k-nearest-neighbors');
%disp('Done!')