function [newfeatures] = gatherFeaturesFromTexture(texture,windowSize)
% Function takes out all the features from the texture
% texture - texture file to implement from
% windowSize - the window size from which features will be taken from

numberOfWindowsInTexture = floor(size(texture)/windowSize);

windowTexture = 0;
newfeatures = 0;

if numberOfWindowsInTexture == 0
    % texture is smaller than window size
    windowTexture = texture;
    %call the feature extraction
else
    %sliding window to extract features from the texture image
    for i = 0 : numberOfWindowsInTexture(1,1) - 1
        for j = 0 : numberOfWindowsInTexture(1,2) - 1
            upperRightCorner = [i*windowSize + 1, j*windowSize + 1];
            windowTexture = texture(upperRightCorner(1,1):(upperRightCorner(1,1)+windowSize), ...
                upperRightCorner(1,2):(upperRightCorner(1,2)+windowSize));
            
            
            %call the outer routines for feature extraction            
            resultOfFeatureVector = ReturnFeatureVector(windowTexture);
            resultOfFreqFeatureVector = texturefrq(windowTexture);
            
            if newfeatures == 0
                %concatenate features
                newfeatures = cat(1,resultOfFeatureVector, resultOfFreqFeatureVector);
            else
            newfeatures = [newfeatures,cat(1,resultOfFeatureVector, resultOfFreqFeatureVector)];
            end

        end
    end
end




