function [features, classes, feature_centers, classes_centers] = gatherFeaturesFromDatabase(database_directory,windowSize)
% function gathers all features and assigned classes from the database 
% directory - directory where the database is
% features - feature vectors
% classes - classes assigned to the feature vectors, (numbering from 0 to number of textures in database)

extension = '*.png';
database_filenames = ls(fullfile(database_directory,extension));
features = 0;
classes = 0;
numberOfClasses = size(database_filenames,1);
for i = 1:numberOfClasses
  
    image = imread(fullfile(database_directory,database_filenames(i,:)));
    if size(size(image),2) == 3 %image is in rgb
        texture = rgb2gray(image);
    else %image is in grayscale
        texture = image;
    end
    
    texture = double(texture);
    %now call feature creation procedures
    
    [newfeatures] = gatherFeaturesFromTexture(texture,windowSize);
    
    %add feauters to the matrices
    if size(features,2) == 1 && size(classes,2) == 1
     features = newfeatures;    
     classes = [i*ones(1,size(features,2))];
     feature_centers = mean(features')';
     classes_centers = database_filenames(i,:); % class center is database filename
    else 
     features = [features, newfeatures];    
     classes = [classes,i*ones(1,size(newfeatures,2))];
     feature_centers = [feature_centers,mean(features')'];
     classes_centers = strvcat(classes_centers,database_filenames(i,:));
    end       
end


% permute the features
npermuts = randperm(size(features,2));
features = features(:,npermuts);
classes = classes(:,npermuts);







