close all
% read image
img = imread('test.pgm');
%img = img(1:100,1:100);
%img = 255-double(img);

% make intensity image
N = 64;
filter = ones(N,N);
filter = filter ./ N;
filter = filter ./ N;
intensity = conv2(img,filter, 'same');
figure, imshow(intensity,[])%Display, scaling data to appropriate range.

% read pattern
%a = imread('small2.pgm');
%a = 255 - double(a);
a=img(140:140+N-1,170:170+N-1); %Extract one of the letters "a" from the image.
figure, imshow(a,[]);%Display, scaling data to appropriate range.

% compute response
C = real(ifft2(fft2(img) .* fft2(a,size(img,1),size(img,2))));

test = abs(fft2(a,size(img,1),size(img,2)));
figure, imshow(test,[]);%Display, scaling data to appropriate range.


% divide response by overall intensity
C = C(2:size(img,1)-1,2:size(img,2)-1);
C2 = 0;
for m = 2:size(C,1)-1
    for n = 2:size(C,2)-1
        C2(m,n) = C(m,n);% / sqrt(intensity(m,n));
    end
end
figure, imshow(C2,[]);%Display, scaling data to appropriate range.

% do other stuff
m = max(C(:)) %Find max pixel value in C.
thresh = 0.9 * m; %Use a threshold that's a little less than max.
C = C > thresh;
%figure, imshow(C3>thresh, [])%Display showing pixels over threshold.
