#include "coarray.h"
#include "stdio.h"
#include "assert.h"
using namespace COLIB;

#define SQR(X) ((X)*(X))

void find_biggest_bounding_box(array2<float> *data, float &xmin, float &xmax, float &ymin, float &ymax) {

xmin = ymin = 100000;
xmax = ymax = 0;
float val;

for (int i=0; i<data->dim(0);i++) {

	// find minimal and maximal y position
	for (int j=1; j<data->dim(1); j+=2) {
		val = (*data)(i,j);
		if (val>ymax) ymax=val;
		if (val<ymin) ymin=val;
		}
	// find minimal and maximal x position
	for (int j=2; j<data->dim(1); j+=2) {
		val = (*data)(i,j);
		if (val>xmax) xmax=val;
		if (val<xmin) xmin=val;
		}

	}
	
} // end find_biggest_bounding_box

void read_data_from_file(array2<float> *img, int &nsamples, int &ndimensions) {

FILE *file;
assert(file=fopen("database.dat", "r"));
fscanf(file, "%d %d ", &nsamples, &ndimensions);

img->resize(nsamples, ndimensions);
float val;
int int_val;
for (int i=0; i<nsamples; i++)
for (int j=0; j<ndimensions; j++) {
	if (j>0) {
		fscanf(file,"%f ", &val);
// 		fprintf(stdout,"%f!  ", val);
		(*img)(i,j) = val;
		}
	else {
		fscanf(file,"%d ", &int_val);
 		fprintf(stdout,"%d!\n", int_val);
		(*img)(i,j) = int_val;
		}
	}

fclose(file);

} // end of read_data_from_file



void print_data_to_file(array2<float> *img, char*filename) {

FILE *file;
assert(file=fopen(filename, "w"));
fprintf(file, "%d %d\n", img->dim(0), img->dim(1));

for (int i=0; i<img->dim(0); i++) {
	fprintf(file,"%d ", (int)(*img)(i,0));
	for (int j=1; j<img->dim(1); j++) 
		fprintf(file,"%f ", (*img)(i,j));
	fprintf(file, "\n");
	}

fclose(file);

} // end of read_data_from_file

void print_data_to_stream(array2<float> *img, FILE *file) {

fprintf(file, "%d %d\n", img->dim(0), img->dim(1));

for (int i=0; i<img->dim(0); i++) {
	fprintf(file,"%d ", (int)(*img)(i,0));
	for (int j=1; j<img->dim(1); j++) 
		fprintf(file,"%f ", (*img)(i,j));
	fprintf(file, "\n");
	}


} // end of read_data_from_file


/*
	description of data format:
		- 21 numbers per line
		- 1st number: class
		- then y x 
		- 10 key points
*/
void normalize_data(array2<float> *data) {

	
float xmin,xmax,ymin,ymax;
float val;

for (int i=0; i<data->dim(0);i++) {

	xmin=10000000,ymin=10000000,xmax=0,ymax=0;

	// find minimal and maximal y position
	for (int j=1; j<data->dim(1); j+=2) {
		val = (*data)(i,j);
		if (val>ymax) ymax=val;
		if (val<ymin) ymin=val;
		}
	// find minimal and maximal x position
	for (int j=2; j<data->dim(1); j+=2) {
		val = (*data)(i,j);
		if (val>xmax) xmax=val;
		if (val<xmin) xmin=val;
		}
	fprintf(stdout, "MINS/MAXES: %f,%f,%f,%f\n", xmin,xmax,ymin,ymax);

	// trick: if equal values

	// normalize data
	for (int j=1; j<data->dim(1); j+=2)
		(*data)(i,j) = -1 + (ymin!= ymax? 2*((*data)(i,j)-ymin)/(ymax-ymin) : 1);
	for (int j=2; j<data->dim(1); j+=2)
		(*data)(i,j) = -1 + (xmin!= xmax? 2*((*data)(i,j)-xmin)/(xmax-xmin) : 1);


	}

} //  end of normalize_data




void split_data(array2<float> *data, array2<float> *test, array2<float> *training) {

test->resize(data->dim(0)/2, data->dim(1));
training->resize(data->dim(0)-test->dim(0), data->dim(1));

int ctest=0,ctraining=0;
for (int i=0; i<data->dim(0); i++) {
	
	if (i%2==1) {
		for (int j=0;j<data->dim(1);j++)
			(*test)(ctest,j)=(*data)(i,j);
		ctest++;
		}
	else {
		for (int j=0;j<data->dim(1);j++)
			(*training)(ctraining,j)=(*data)(i,j);
		ctraining++;
		}

	} // end of loop

fprintf(stdout, "trainingset: \n");
print_data_to_stream(training, stdout);
fprintf(stdout, "testset: \n");
print_data_to_stream(test, stdout);

} // end split_data



float dist(array2<float> *data1, int i, array2<float> *data2, int j) {
float dist = 0;
for (int k=1; k<data1->dim(1);k++) {
	dist += SQR((*data1)(i,k)-(*data2)(j,k));
	}
return dist;
} // end dist

bool same_class(array2<float> *data1, int i, array2<float> *data2, int j) {
return (*data1)(i,0)==(*data2)(i,0);
}

int get_class (array2<float> *data, int i) {
return (int)(*data)(i,0);
}

/* fuer mehr: extra datenstruktur schreiben, damit ich qsort von daheim drauf anwenden kann!*/
void classify_data_nearest_neighbor(array2<float> *trainingset, array2<float> *testset) {

int ncorrect = 0;
int nwrong = 0;

int best_index=-1;
float best_distance;
float d;
for (int i=0;i<testset->dim(0);i++) {

fprintf(stdout, "test pattern no.%d\n", i);
	
	// classify new vector!
	best_distance=1000000000.;
	for (int j=0;j<trainingset->dim(0);j++) {
		d = dist(testset,i,trainingset,j);
fprintf(stdout, "  training pattern no.%d: dist = %f\n", j, d);
		if (d<best_distance) {
			best_distance=d;
			best_index=j;
			}
		}

fprintf(stdout, "   choosing %d \n", best_index);
fprintf(stdout, "   class(test)=%d, class(best)=%d \n", get_class(testset,i),get_class(trainingset,best_index) );

	// check whether classification is right!
	if (best_index==-1) 
		fprintf(stdout, "should not happen!");
	if (same_class(testset,i,trainingset,best_index))
		ncorrect++;
	else nwrong++;
	
	} // end loop of classifications


fprintf(stdout, "\n\nCLASSIFICATION RESULT: %d correct, %d wrong!\n", ncorrect,nwrong);

} // end classify_data_nearest_neighbor



int main(int argc, char* argv) {

array2<float> *data = new array2<float>;
array2<float> *testset = new array2<float>;
array2<float> *trainingset = new array2<float>;
int nsamples, dim;
read_data_from_file(data, nsamples, dim);

float xmin,xmax,ymin,ymax;
find_biggest_bounding_box(data, xmin, xmax,ymin, ymax);

fprintf (stderr, "\n\nBIGGEST BOUNDING BOX ENCLOSING ALL = [%f,%f] x [%f,%f]\n", xmin,xmax,ymin,ymax);

} // end of main
