#include "evobintom3D.h"
#include <stdio.h>
#include <math.h>
#include <time.h>

#define DEFAULT_OUTPUT_FILE "projections.txt"
#define DEFAULT_CONF_FILE "Sphare_conf.txt"
#define DEFAULT_PIC_SIZE    50

int main(int argc, char*argv[]){
    char *outputFileName = DEFAULT_OUTPUT_FILE;
    char *confFile = DEFAULT_CONF_FILE;
    Proj *outputProj;                            /* output projections*/
    Conf conf;                                   /* configuration of sphares */
    int i;
    int help = FALSE;

    picSize = DEFAULT_PIC_SIZE; /* global variable from evobintom3D.h */

    /* Processing command-line */
    i = 1;
    while ( i < argc ) {
       if ( argv[i][0] == '-' ) {
          switch ( argv[i][1] ) {
              /* help */
              case '?': help = TRUE; break;
              /* change output file */
              case 'o': if (argc>=i+1){outputFileName = argv[i+1]; i++;} break;
              case 'c': if (argc>=i+1){confFile = argv[i+1]; i++;} break;
              case 'p': if (argc>=i+1){picSize = atoi(argv[i+1]); i++;} break;
              default : break;
          }
       }
       i++;
    }
    if (picSize<=0)picSize = DEFAULT_PIC_SIZE;
    if (confFile<=0)confFile = DEFAULT_CONF_FILE;

    if (help) {
        printf("-?             --  print this help\n");
        printf("-o [filename]  --  change the output filename\n");
        printf("-c [number]    --  change the configuration file name\n");
        printf("-p [number]    --  change the picture size\n");
        return 0;
    }

    outputProj = (int*)malloc(3*picSize*picSize*sizeof(int));
    if (!outputProj){ printf("Can't allocate memory for projections.\n"); return -1; }

    init();

    /* generate configuration */
    if (!genInitPop(&conf, 1)) {
        printf("Can't generate initial population.\n");
        return 1;
    }

    /* write configuration */
    if (!writeConf(confFile, &conf)){ printf("Can't write configuration.\n"); return -1;}

    /* calculate projections */
    makeProjs(&conf, outputProj);

    /* write projections */
    if (!writeProjs(outputFileName, outputProj)){ printf("Can't write projections.\n"); return -1;}
    
    free (outputProj);
    free (conf.data);

    return 0;
}
