/**
  *  An evolutionary approach to reconstruct 3D binary images by their projections
  *  SSIP 2009 -- Team 2 -- Project 11: Binary Tomography
 **/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include "evobintom3D.h"

#define DEFAULT_INPUT_FILE "projections.txt"
#define DEFAULT_OUTPUT_FILE "result_conf.txt"
#define DEFAULT_POP_SIZE 1000
#define DEFAULT_MAX_ITER 3000
#define DEFAULT_EPSILON  0
#define DEFAULT_POS_CO   0.15
#define DEFAULT_POS_M_NR 0.15
#define DEFAULT_POS_M_MO 0.15
#define DEFAULT_POS_M_SI 0.15

int main(int argc, char* argv[]){
    int help = FALSE;
    char *inputFileName  = DEFAULT_INPUT_FILE;
    char *outputFileName = DEFAULT_OUTPUT_FILE;
    int  popSize = DEFAULT_POP_SIZE;     /* size of population */
    int  i;
    FILE *outFile;
    Proj *inputProj;                     /* input projections*/
    Conf *population;                    /* array to store the instances of the population */
    int  *fitness;                       /* array to store the fitness values */
    int  bestfitness;                    /* the best fitness */
    int  bestitem;                       /* the item belongs to the best fitness */
    int  iter;                           /* number of iterations */
    int  maxiter;                        /* maximum number of iterations */
    int  epsilon = DEFAULT_EPSILON;      /* the epsilon value for the fitness */

    /* Processing command-line */
    i = 1;
    while ( i < argc ) {
       if ( argv[i][0] == '-' ) {
          switch ( argv[i][1] ) {
              /* help */
              case '?': help = TRUE; break;
              /* change input file */
         	  case 'i': if (argc>=i+1){inputFileName = argv[i+1]; i++;} break;
              /* change output file */
              case 'o': if (argc>=i+1){outputFileName = argv[i+1]; i++;} break;
              /* change the population size */
              case 'p': if (argc>=i+1){popSize = atoi(argv[i+1]);
                            if (popSize<=0) popSize = DEFAULT_POP_SIZE; 
                            i++;} break;
              /* change the maximum iteration number */
              case 'm': if (argc>=i+1){maxiter = atoi(argv[i+1]);
                            if (maxiter<=0) maxiter = DEFAULT_MAX_ITER; 
                            i++;} break;
              /* change the epsilon value */
              case 'e': if (argc>=i+1){epsilon = atoi(argv[i+1]);
                            if (epsilon<=0) epsilon = DEFAULT_EPSILON; 
                            i++;} break;
              /* change the possibility of operations */
              case '1': if (argc>=i+1){pos_CO = atof(argv[i+1]);
                            /*if (pos_CO<=0) pos_CO = DEFAULT_POS_CO; */
                            i++;} break;
              case '2': if (argc>=i+1){pos_m_nr = atof(argv[i+1]);
                            /*if (pos_m_nr<=0) pos_m_nr = DEFAULT_POS_M_NR; */
                            i++;} break;
              case '3': if (argc>=i+1){pos_m_move = atof(argv[i+1]);
                            /*if (pos_m_move<=0) pos_m_move = DEFAULT_POS_M_MO; */
                            i++;} break;
              case '4': if (argc>=i+1){pos_m_size = atof(argv[i+1]);
                            /*if (pos_m_size<=0) pos_m_size = DEFAULT_POS_M_SI; */
                            i++;} break;
              default : break;
          }
       }
       i++;
    }

    if (help) {
        printf("-?             --  print this text\n");
        printf("-i [filename]  --  change the input filename\n");
        printf("-o [filename]  --  change the output filename\n");
        printf("-p [number]    --  change the size of the population\n");
        printf("-e [number]    --  change the epsilon value\n");
        printf("-m [number]    --  change the maximum number of iterations\n");
        printf("-1 [number]    --  change the possibility of crossover\n");
        printf("-2 [number]    --  change the possibility of mutation(increase/decrease the number of sphares)\n");
        printf("-3 [number]    --  change the possibiliti of mutation(move one sphare)\n");
        printf("-4 [number]    --  change the possibiliti of mutation(resize one sphare)\n");
        return 0;
    }

    /* read input projections from input file */
    inputProj = readInput(inputFileName);
    if (!inputProj){
        printf("Can't read input projections.\n");
        return 1;
    }

    /* initialization */
    if (!init()){
        printf("Can't initialize the program.\n");
        return 1;
    }

    population = (Conf*)malloc(popSize*sizeof(Conf));
    if (!population) { printf("Can't allocate memory for configurations.\n"); return FALSE; }

    /* generate initial population */
    if (!genInitPop(population, popSize)) {
        printf("Can't generate initial population.\n");
        return 1;
    }

    /* calculate fitness and store it */
    fitness = (int*)malloc(popSize*sizeof(int));
    if (!fitness) { printf("Can't allocate memory for fitness values.\n"); return FALSE; }

    for (i=0; i<popSize; i++){
        fitness[i] = calcFitness(&population[i], inputProj);
    }

    /* start the evolutionary algorithm */
    iter = 0;
    bestfitness = INT_MAX;
    bestitem = -1;
    worstfitness = 0;
    for (i=0; i<popSize; i++){
        if (worstfitness<fitness[i]){worstfitness = fitness[i];worstplace = i;}
        if (bestfitness >fitness[i]){bestfitness = fitness[i]; bestitem = i;}
    }
printf("best fitness: %d\n", bestfitness);
    while (iter<maxiter && epsilon<bestfitness){
        if (!nextGeneration(inputProj, population, fitness, popSize, &bestfitness, &bestitem)){printf("Can't do nextGeneration.\n");return -1;}
        /* simplify the configurations */
        if (iter % 10 == 0){
            if (!simplify(population, popSize)){printf("Can't do the simplification.\n");return -1;}
        }
        iter++;
printf("iteration: %d - best fitness: %d (%d)\n", iter, bestfitness, bestitem);
    }

    if (!simplify(population, popSize)){printf("Can't do the simplification.\n");return -1;}

    /* write the best value */
    if (!(outFile = fopen(outputFileName, "w"))){
        printf("Can't open output file");
        if (0<=bestitem){
            printf("%d\n", population[bestitem].nrObjects);
            for (i=0; i<population[bestitem].nrObjects; i++){
                printf("%d %d %d %d\n", population[bestitem].data[i].x, population[bestitem].data[i].y, population[bestitem].data[i].z, population[bestitem].data[i].r);
            }
        }
        return -1;
    }
    if (0<=bestitem){
        fprintf(outFile, "%d\n", population[bestitem].nrObjects);
        for (i=0; i<population[bestitem].nrObjects; i++){
            fprintf(outFile, "%d %d %d %d\n", population[bestitem].data[i].x, population[bestitem].data[i].y, population[bestitem].data[i].z, population[bestitem].data[i].r);
        }
    }

    free (population->data);
    free (population);
    free (inputProj);
    free (nG);

    return 0;
}
