/* adding uniform noise to the projections */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/* this macro generates a random number between the two given integers */
#define getrandom( min, max ) ((rand() % (int)(((max)+1) - (min))) + (min))


int main(int argc, char* argv[]){
    int i;
    FILE* input;
    FILE* output;
    int *proj;
    int picSize;
    int max = 0;
    double percent;

    if (argc!=4){
        printf("usage: %s inputfile outputfile percentage_of_noise\n", argv[0]);
        return 0;
    }

    srand(time(NULL));

    input = fopen(argv[1], "r");
    if (!input) { printf("Can't open input file.\n"); return -1; }

    if (1 != fscanf(input, "%d", &picSize)){ printf("Can't read picture size.\n"); return -1; }
    
    if (picSize <= 0) { printf("Wrong picture size.\n"); return -1; }

    proj = (int*)malloc(3*picSize*picSize*sizeof(int));
    if (!proj){ printf("Can't allocate memory for projection data.\n"); return -1; }
    
    for (i=0; i<3*picSize*picSize; i++){
        if (1 != fscanf(input, "%d", &proj[i])){ printf("Can't read projection data.\n"); return -1; }
        if (proj[i]>max) max = proj[i];
    }
    
    fclose(input);
    output = fopen(argv[2], "w");
    if (!input) { printf("Can't open output file.\n"); return -1; }
    fprintf(output, "%d\n", picSize);

    percent = atof(argv[3]);
    
    for (i=0; i<3*picSize*picSize; i++){
        if (max>0){
            proj[i] += getrandom(-max/2, max/2);
        }
        fprintf(output, "%d ", (proj[i]<0?0:proj[i]));
    }
    
    fclose(output);

    return 0;
}
